/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1999 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"

#include "CProdUtils.h"

#include <afxpriv.h>
#include <atlconv.h>
#include <math.h>

// Declarations of Global Variables

extern IApplication *pdApp;
extern IHelm *pHelm;
LPOLESTR pszDisplayName = NULL;

// Definitions of Global Functions begin here

HRESULT RunProDESKTOP(IApplication **app) 
{

	// Invokes ProDESKTOP Application and sets the visiblity ON

	pdApp = NULL;

	HRESULT hr;

	hr = CoCreateInstance(CLSID_ProDESKTOP, NULL, CLSCTX_SERVER, IID_IApplication, (void**)&pdApp);
	if(FAILED(hr) || !pdApp) {
		AfxMessageBox("Could not invoke ProDESKTOP Application");
		return E_FAIL;
	}

	hr = (pdApp)->SetVisible(TRUE);
	if(FAILED(hr)) {
		AfxMessageBox("SetVisible failed");
		return E_FAIL;
	}

	*app = pdApp;

	return S_OK;
}

HRESULT CloseProDESKTOP() 
{

// Closes ProDESKTOP Application and releases the Application pointer.

	HRESULT hr;

	if (!pdApp) {
#if _DEBUG
		AfxMessageBox("Could not get the Pro/Desktop application.");
#endif
		return E_FAIL;
	}

	hr = pdApp->SetVisible(FALSE);
	if(FAILED(hr)) {
#if _DEBUG
		AfxMessageBox("SetVisible failed");
#endif
		return E_FAIL;
	}

	while(hr = pdApp->Release()) {}

	pdApp = NULL;

	return S_OK;
}

HRESULT GetProDESKTOPApplication(IApplication **ProDESKTOPApp)
{

	//	Returns the ProDESKTOP Application

	*ProDESKTOPApp = NULL;

	if(!pdApp) 
		return E_FAIL;

	*ProDESKTOPApp = pdApp;
	return S_OK;
}

HRESULT GetActiveWorkplaneSketch(	 IGraphicDocument **activeGraphicDoc,
									 IWorkplane **activeWorkplane,
									 ISketch **activeSketch)
{

//  Queries the   Workplane , and Sketch Interfaces and
//	returns the  active Workplane, active Sketch
	
	HRESULT status = NOERROR;

	IWorkplane *workplane = NULL;

	ISketch * sketch = NULL;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	if (status!=0 || !pdApplication) {
		AfxMessageBox("Could not get ProDESKTOP application");
		return E_FAIL;
	}

	status = pdApplication->GetActiveDoc(activeGraphicDoc);

	if(status!=0 || !activeGraphicDoc) {
		AfxMessageBox("GetActiveDoc failed");
		return E_FAIL ;
	}

	// Get active workplane
	status = (*activeGraphicDoc)->GetActiveWorkplane(activeWorkplane);

	if(status!=0 || !activeWorkplane) {
		AfxMessageBox("GetActiveWorkplane failed");
		return E_FAIL ;
	}

	// Get active sketch
	status = (*activeGraphicDoc)->GetActiveSketch(activeSketch);

	if(status!=0 || !activeSketch) {
		AfxMessageBox("GetActiveSketch failed");
		return E_FAIL ;
	}

	return S_OK;
}


bool IsFileSaved(IGraphicDocument *activeGraphicDoc)
{
	HRESULT hr;
	USES_CONVERSION;

	IObject *pObj = NULL;
	hr = activeGraphicDoc->GetContent(&pObj);
	if (hr!=0 || !pObj)
		return false;

	IFile *file = NULL;
	hr = pObj->GetFile(&file);
	if (hr!=0 || !file)
		return false;

	LPOLESTR name;
	file->GetName(&name);
	CString fileName = OLE2T(name);
	return fileName.Compare("") == 0 ? false : true;
}

//	Creates a line using the two given points
//	and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLine(double startX, double startY, double endX, double endY, ILine **dCurve1)
{
	HRESULT status = S_OK;
	
	IApplication *app = NULL;

	status = GetProDESKTOPApplication(&app);
	if (status!=0 || !app) {
		AfxMessageBox("Could not get ProDESKTOP application");
		return E_FAIL;
	}

	IGraphicDocument *activeGraphicDoc;
	IPartDocument * activePart = NULL;
	IWorkplane * activeWorkplane = NULL;
	ISketch * activeSketch = NULL;

	status = GetActiveWorkplaneSketch(&activeGraphicDoc, &activeWorkplane, &activeSketch);
	if (status!=0 || !activeWorkplane || !activeSketch)
		return E_FAIL;

	// Create the startVector
	IVector *startVector2D = NULL;

	status = (GetCLASS(Vector))->CreateVector(startX, startY, 0, &startVector2D);
	if (status!=0 || !startVector2D) {
		AfxMessageBox("CreateVectorXYZ failed");
		return E_FAIL;
	}

	// Get the 3D vector for startVector
	IVector *startVector3D = NULL;
	status = activeWorkplane->Get3DVector(startVector2D, &startVector3D);
	if (status!=0 || !startVector3D) {
		AfxMessageBox("Get3DVector failed");
		return E_FAIL;
	}

	// Create the endVector
	IVector *endVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(endX, endY, 0, &endVector2D);
	if (status!=0 || !endVector2D) {
		AfxMessageBox("CreateVectorXYZ failed");
		return E_FAIL;
	}

	// Get the 3D vector for endVector
	IVector *endVector3D = NULL;
	status = activeWorkplane->Get3DVector(endVector2D, &endVector3D);
	if (status!=0 || !endVector3D) {
		AfxMessageBox("Get3DVector failed");
		return E_FAIL;
	}

	// Create basic straight line
	IBasicStraight *curve1 = NULL;

	// Currently, we are using the startVector2D and endVector2D
	// which are in the active workplane local co-ordinates.
	// These will be changed to take "Global Co-ordinates - 3D vectors
	// startVector3D, endVector3D

	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(startVector3D, endVector3D, &curve1);
	if (status!=0 || !curve1) {
		AfxMessageBox("CreateBasicStraightTwoPoints failed");
		return E_FAIL;
	}

	// Create aLine object
	ILine *line1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve1), &line1);
	if (status!=0 || !line1) {
		AfxMessageBox("CreateLine failed");
		return E_FAIL;
	}

	*dCurve1 = line1;

	// Apply AutoConstrain on the line created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, line1));
	if(status!=0) {
		AfxMessageBox("AutoConstrain failed");
		return E_FAIL;
	}

	// Set the selection to the line created
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, line1));
	if(status!=0) {
		AfxMessageBox("SetSelection failed");
		return E_FAIL;
	}

	// Update the views
	CString str = "Operation";
	status = pHelm->CommitCalls(str.AllocSysString(), FALSE);

	if( status!=0 )
		return E_FAIL;

	return S_OK;
}
